﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="System.Web.UI.Page" %>

<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="FiftyOne.Framework.Mobile.Profile" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server" type="text/C#">
 
    private SortedList<string, string> _list;

    /// <summary>
    /// Provides the list of email addresses and unique IDs.
    /// </summary>
    private SortedList<string, string> List
    {
        get
        {
            if (_list != null)
                return _list;

            // Get a list of the email address contained in the raw data provided.
            _list = new SortedList<string, string>();
            if (String.IsNullOrEmpty(TextBoxCapture.Text) == false)
            {
                MatchCollection matches = Regex.Matches(TextBoxCapture.Text,
                    @"[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?");
                foreach (Match match in matches)
                {
                    if (match.Success && String.IsNullOrEmpty(match.Value) == false)
                    {
                        FiftyOne.Framework.Mobile.Profile.ProfileBase newProfile =
                            MobileProfiles.Contains(match.Value) ? 
                                MobileProfiles.GetProfile(match.Value) : 
                                MobileProfiles.Create(match.Value);
                        if (_list.ContainsKey(match.Value) == false)
                            _list.Add(match.Value, newProfile.ProfileID);
                    }
                }
            }
            return _list;
        }
    }

    /// <summary>
    /// Set the visibility of the different panels.
    /// </summary>
    public void Page_PreRender(object sender, EventArgs e)
    {
        PanelNoAccess.Visible = !Request.IsLocal;
        PanelCapture.Visible = Request.IsLocal && String.IsNullOrEmpty(TextBoxCapture.Text);
        PanelResults.Visible = Request.IsLocal && !PanelCapture.Visible;
    }

    /// <summary>
    /// Use a regular expression to split out the mobile numbers and populate
    /// the results grid.
    /// </summary>
    public void PanelResults_PreRender(object sender, EventArgs e)
    {
        // Use this list as the data source of the GridView.
        GridViewResults.DataSource = List;
        GridViewResults.DataBind();
    }

    /// <summary>
    /// Reset the textbox.
    /// </summary>
    public void ButtonReset_Click(object sender, EventArgs e)
    {
        TextBoxCapture.Text = null;
    }

    /// <summary>
    /// Returns a CSV as the response.
    /// </summary>
    public void ButtonCSV_Click(object sender, EventArgs e)
    {
        Response.ContentType = "text/csv";
        if (List.Count > 0)
        {
            using (StreamWriter writer = new StreamWriter(Response.OutputStream))
            {
                foreach (string key in List.Keys)
                {
                    writer.WriteLine(String.Format("{0},\"{1}\"", key, List[key]));
                }
            }
        }
        Response.End();
    }
    
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Create Email IDs Example</title>
</head>
<body>
    <form id="formMain" runat="server">
    <div>
        <asp:Panel runat="server" ID="PanelNoAccess">
            <asp:Label runat="server" ID="LabelNoAccess" ForeColor="Red">
                This page can only be accessed from a browser running on the local server.
            </asp:Label>
        </asp:Panel>
        <asp:Panel runat="server" ID="PanelCapture">
            <asp:Label runat="server" ID="LabelCapture" Text="Paste a List of Email Addresses into the TextBox" />
            <br />
            <br />
            <asp:TextBox runat="server" ID="TextBoxCapture" TextMode="MultiLine" Rows="5" Width="100%" />
            <br />
            <br />
            <asp:Button runat="server" ID="ButtonSubmit" Text="Preview" UseSubmitBehavior="true" />
        </asp:Panel>
        <asp:Panel runat="server" ID="PanelResults" OnPreRender="PanelResults_PreRender">
            <asp:Label runat="server" ID="LabelResults" Text="Email Addreeses &amp; Unique Mobile Profile IDS" />
            <br />
            <br />
            <asp:GridView runat="server" ID="GridViewResults" />
            <br />
            <br />
            <asp:Button runat="server" ID="ButtonCSV" Text="Download as CSV File" UseSubmitBehavior="true"
                OnClick="ButtonCSV_Click" />
            <asp:Button runat="server" ID="ButtonReset" Text="Reset" UseSubmitBehavior="true"
                OnClick="ButtonReset_Click" />
        </asp:Panel>
    </div>
    </form>
</body>
</html>
